//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "UnitFormMain.h"
#include <memory>
#include <Vcl.Clipbrd.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;
//---------------------------------------------------------------------------
/**
 * vJ[\\
 */
class TCursorHourGlass
{
public:
  TCursorHourGlass(TCursor Cursor=crHourGlass) : FCursor(Screen->Cursor) {
    Screen->Cursor = Cursor;
  }
  ~TCursorHourGlass() {
    Screen->Cursor = this->FCursor;
  }
private:
  TCursor FCursor;
};
//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner)
  : TForm(Owner)
{
  ActionSaveToCsv->Enabled = false;
  ListView1Click(NULL);
}
//---------------------------------------------------------------------------
/**
 * Win32APĨG[bZ[W擾
 */
UnicodeString GetLastErrorString()
{
  wchar_t buf[1024] = {};
  const int errCode = GetLastError();
  FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, errCode, LANG_SYSTEM_DEFAULT, buf, 1024, NULL);
  return buf;
}
//---------------------------------------------------------------------------
/**
 * EnumWindowsĂяoR[obN֐
 */
BOOL CALLBACK EnumWindowsProc(HWND hwnd , LPARAM lp)
{
  //^Cg̕擾
  const int WINDOW_TEXT_LEN = GetWindowTextLength(hwnd) + 1;
  std::unique_ptr<wchar_t[]> title(new wchar_t[WINDOW_TEXT_LEN]);
  //^CgEChE
  const bool HAS_WINDOW = (GetWindowText(hwnd , title.get() , WINDOW_TEXT_LEN) != 0);
  if (FormMain->CheckBoxHasTitle->Checked && (HAS_WINDOW == false)) return true;
  //\ĂEChE
  if (FormMain->CheckBoxIsVisible->Checked && IsWindowVisible(hwnd) == 0) return true;

  TListItem* item = FormMain->ListView1->Items->Add();
  item->SubItems->Add(UnicodeString(title.get(), WINDOW_TEXT_LEN));

  //NX
  wchar_t className[1024] = {};
  if (GetClassName(hwnd, className, 1024) == 0)
  { //G[̎
    const UnicodeString msg = L"~G[:" + GetLastErrorString();
    item->Caption = msg;
    FormMain->StatusBar1->SimpleText = msg;
  }
  else
  {
    item->Caption = className;
  }
  return true;
}
//---------------------------------------------------------------------------
/**
 * ǂݍ
 */
void __fastcall TFormMain::ActionWindowReloadExecute(TObject *Sender)
{
  TCursorHourGlass cursor;
  if (ActionSaveToCsv->Enabled == false) { ActionSaveToCsv->Enabled = true; }
  try
  {
    //\[gZbg
    this->FColumnIndex = -1;
    this->FSortType = false;

    ListView1->Items->BeginUpdate();
    ListView1->Items->Clear();
    EnumWindows(EnumWindowsProc, 0);
    ListView1->Columns->Items[0]->Width = -2;
    ListView1->Columns->Items[1]->Width = -2;
    if (ListView1->Items->Count > 0) { ListView1->Items->Item[0]->Selected = true; }
    ListView1Click(NULL);
  }
  __finally
  {
    ListView1->Items->EndUpdate();
  }
}
//---------------------------------------------------------------------------
/**
 * \[g̔r֐
 */
void __fastcall TFormMain::ListView1Compare(TObject *Sender, TListItem *Item1, TListItem *Item2,
          int Data, int &Compare)
{
  switch (this->FColumnIndex) {
    case 0: //NX
      Compare = AnsiCompareStr(Item1->Caption, Item2->Caption);
      break;
    default:
      Compare = AnsiCompareStr(Item1->SubItems->Strings[this->FColumnIndex - 1], Item2->SubItems->Strings[this->FColumnIndex - 1]);
      break;
  }

  //tɃ\[g
  if (this->FSortType) { Compare *= -1; }
}
//---------------------------------------------------------------------------
/**
 * wb_[NbNꂽ̓\[g
 */
void __fastcall TFormMain::ListView1ColumnClick(TObject *Sender, TListColumn *Column)
{
  TCursorHourGlass cursor;
  const int COL_INDEX = Column->Index;

  //񂪃NbNꂽ́A\[gtɂ
  if (this->FColumnIndex == COL_INDEX)
    this->FSortType = !this->FSortType;
  else
    this->FSortType = false;
  this->FColumnIndex = COL_INDEX;

  ListView1->CustomSort(NULL, 0);
  StatusBar1->SimpleText = L"\[g܂B";
}
//---------------------------------------------------------------------------
/**
 * CSVt@Cɕۑ
 */
void __fastcall TFormMain::ActionSaveToCsvExecute(TObject *Sender)
{
  if (SaveDialogCsv->Execute() == false) { return; }

  TCursorHourGlass cursor;
  std::unique_ptr<TStringList> file(new TStringList());
  {
    const int COL_COUNT = ListView1->Columns->Count;
    std::unique_ptr<TStringList> line(new TStringList());
    //wb_[
    for (int i = 0; i < COL_COUNT; ++i)
    {
      line->Add(ListView1->Column[i]->Caption);
    }
    file->Add(line->CommaText);
    //f[^
    for (int row = 0; row < ListView1->Items->Count; ++row)
    {
      line->Clear();
      TListItem* item = ListView1->Items->Item[row];
      for (int col = 0; col < COL_COUNT; ++col)
      {
        switch (col) {
          case 0:
            line->Add(item->Caption);
            break;
          default:
            line->Add(item->SubItems->Strings[col - 1]);
            break;
        }
      }
      file->Add(line->CommaText);
    }
  }
  try
  {
    file->SaveToFile(SaveDialogCsv->FileName);
    StatusBar1->SimpleText = L"t@Cɕۑ܂B";
  }
  catch (Exception &E)
  {
    MessageDlg(E.Message, mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::ListView1Click(TObject *Sender)
{
  const bool SELECTED = (ListView1->ItemIndex >= 0);
  ActionCopyClassName->Enabled = SELECTED;
  ActionCopyWindowTitle->Enabled = SELECTED;
}
//---------------------------------------------------------------------------
/**
 * IĂNXNbv{[hɃRs[܂B
 */
void __fastcall TFormMain::ActionCopyClassNameExecute(TObject *Sender)
{
  TCursorHourGlass cursor;
  TListItem* item = ListView1->Selected;
  if (item == NULL) { return; }
  try
  {
    Clipboard()->AsText = item->Caption;
    StatusBar1->SimpleText = L"Nbv{[hɃRs[܂B";
  }
  catch (Exception &E)
  {
    MessageDlg(E.Message, mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//---------------------------------------------------------------------------
/**
 * IĂEBhE^CgNbv{[hɃRs[܂B
 */
void __fastcall TFormMain::ActionCopyWindowTitleExecute(TObject *Sender)
{
  TCursorHourGlass cursor;
  TListItem* item = ListView1->Selected;
  if (item == NULL) { return; }
  try
  {
    Clipboard()->AsText = item->SubItems->Strings[0];
    StatusBar1->SimpleText = L"Nbv{[hɃRs[܂B";
  }
  catch (Exception &E)
  {
    MessageDlg(E.Message, mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//---------------------------------------------------------------------------
