<?php

define('ENCODING', 'UTF-8');
//キャッシュフォルダの場所
//define('MAGPIE_CACHE_DIR', '/tmp/magpierss');
//キャッシュを無効にする
//define('MAGPIE_CACHE_ON', 0);
//キャッシュの寿命
//define('MAGPIE_CACHE_AGE', 60*60); //1時間
//文字コード
define('MAGPIE_OUTPUT_ENCODING', 'UTF-8');

mb_language('Japanese');
mb_internal_encoding(ENCODING);
ini_set('mbstring.http_input', 'pass');
ini_set('mbstring.http_output', 'pass');
ini_set('mbstring.script_encoding'  , 'UTF-8');
mb_detect_order('auto');

//文字コードをUTF-8に変換する
function to_utf8($str) {
  return mb_convert_encoding($str, ENCODING, "auto");
}
//半角文字を全角に変換する
function to_zen($str) {
  return mb_convert_kana($str, 'RNASKHV', ENCODING);
}
//長さが1以上か調べる
function exist_data($str) {
  return strlen($str) > 0;
}

$url = $_GET['u']; //RSSのURL
$keyword = $_GET['q']; //検索キーワード(空白で複数指定可能)

if (strlen($url) == 0 || strlen($keyword) == 0) {
  header("Content-Type: text/html;charset=UTF-8");
  echo "URLまたは検索キーワードが指定されていません。";
  exit;
}

$keyword = to_zen(to_utf8($keyword));  //検索キーワードを全角に変換する
$keywords = explode('　', $keyword);
$keywords = array_filter($keywords, 'exist_data'); //空の要素を削除する
sort($keywords, SORT_STRING);
$filename = urlencode($url.';q='.implode(' ', $keywords)); //保存するファイル名(url + キーワードのurl encode)

require_once 'rss_fetch.inc';
$parser = fetch_rss($url); //読み込み

//RSSを作成する
include("feedcreator.class.php");
$rss = new UniversalFeedCreator();
$rss->encoding = 'UTF-8';
$rss->useCached();
$rss->title = to_utf8($parser->channel['title']);
$rss->description = to_utf8($parser->channel['description']);
$rss->link = $parser->channel['link'];
$rss->image = $parser->channel['image'];

foreach ($parser->items as $item) {
  //タイトルか要約に検索キーワードが含まれているか
  $matched = TRUE;
  $title = to_zen(to_utf8($item[title]));
  $description = to_zen(to_utf8($item[description]));
  foreach ($keywords as $keyword) {
    //1つでもキーワードが見つからないときは終了
    if (stristr($title, $keyword) === FALSE && 
        stristr($description, $keyword) === FALSE) {
      $matched = FALSE;
      break;
    }
  }
  //見つからないキーワードがあるときはスキップ
  if ($matched == FALSE) {
    continue; 
  }

  //フィードを作成する
  $feeditem = new FeedItem();
  $feeditem->title = to_utf8($item[title]);
  $feeditem->link = $item[link];
  $feeditem->description = to_utf8($item[description]);
  $feeditem->date = $item[dc][date];
  $feeditem->source = $item[source];
  $feeditem->author = $item[author];
  $rss->addItem($feeditem);
}

//$rss->saveFeed("RSS2.0", "feed/feed.xml", FALSE);
$rss->saveFeed("RSS2.0", "feed/{$filename}");
?>
